Methods are executed by calling specific URLs and fetching the formatted output. Here's an example of URL:

<{code inline=false}>http://site.com/activecollab/public/api.php?path_info=COMMAND&auth_api_token=TOKEN<{/code}>

Some requests may require more parameters. These parameters are added as regular query string (GET) parameters to the URL. Here is an example with two additional parameters:

<{code inline=false}>http://site.com/activecollab/public/api.php?path_info=COMMAND&auth_api_token=TOKEN&variable1=value1&variable2=value2<{/code}>

The API URL that you need to use to send a request (and your tokens for different clients) are available on the <{option}>API Subscriptions<{/option}> page of your profile page in activeCollab:

<{image name='api-url-and-token.jpg'}>

<{sub slug='response-format'}>Specifying Response Format<{/sub}>

activeCollab API can return response in two formats: XML and JSON. If you wish to receive XML response, you don't need to specify a format since XML is default response format. To tell activeCollab to return JSON, use one of the following methods:

1. Set <{code}>Accept<{/code}> header to <{code}>application/json<{/code}>
2. Add <{code}>format<{/code}> GET variable and set it to <{code}>json<{/code}>

Examples:

<{code}>curl -H "Accept: application/json" "http://site.com/activecollab/api.php?path_info=info&auth_api_token=XYZ"
curl "http://site.com/activecollab/api.php?path_info=info&auth_api_token=XYZ&format=json"<{/code}>